#ifndef __MT_WINDOW_H__
#define __MT_WINDOW_H__

enum MTWindowControlType
{
	kGenericControlType = 0,
	kButtonControlType,
	kHorzScrollBarType,
	kVertScrollBarType
};

enum MTWindowType
{
	kFileListType,
	kTXMPViewerType,
	kInfoWindowType,
	kGrafPortWindowType,
	kEditorWindowType
};

const UInt32	kMaxButtonControls = 32;
const UInt32	kMTWindowTypeFlag = 'MTWd';
const UInt32	kScrollBarSize = 16;

class MTFileList;

class MTWindow
{
	public:
								MTWindow();
		virtual					~MTWindow();
		
		void					Open(void);
		void					Close(void);
		
		void					BringToFront(void)	{ SelectWindow(theWindow); }
		
		virtual void			HandleOpenEvent(void) = 0;
		virtual void			HandleCloseEvent(void) = 0;
		virtual void			HandleContentEvent(EventRecord * theEvent, UInt32 flags) = 0;
		virtual void			HandleResizeEvent(SInt32 newWidth, SInt32 newHeight) = 0;
		virtual void			HandleUpdateEvent(void) = 0;
		
		virtual void			HandleScrollEvent(MTWindowControlType which, SInt32 value) = 0;
		virtual void			HandleControlEvent(ControlHandle theControl, SInt16 thePart) = 0;
		virtual void			HandleButtonEvent(ControlHandle theControl) = 0;
		virtual void			HandleKeyEvent(EventRecord * theEvent, UInt8 charCode, UInt8 keyCode, EventModifiers modifiers) = 0;
		
		virtual void			GetZoomSizeBounds(Rect * bounds) = 0;
		virtual UInt8			IsUniqueWindow(void) = 0;
		
		UInt8					operator==(WindowPtr rhs);
		
		UInt8					AutoHandleControls(EventRecord * theEvent);
		
		UInt8					IsHorzScroll(ControlHandle theControl)	{ return (GetControlReference(theControl) == kHorzScrollBarType); }
		UInt8					IsVertScroll(ControlHandle theControl)	{ return (GetControlReference(theControl) == kVertScrollBarType); }
		
		virtual MTWindowType	GetBaseWindowType(void) = 0;
		
		static pascal void		ScrollActionProc(ControlRef theControl, ControlPartCode partCode);
		
		virtual void			GetWindowName(StringPtr theString) = 0;
		
		virtual void			RecieveMessage(UInt32 messageType, UInt32 messageData) = 0;
		virtual UInt8			SupportsMessage(UInt32 messageType, UInt32 messageData) = 0;
		
		void					SetOwner(MTWindow * inWindow)	{ owner = inWindow; }
		MTWindow *				GetOwner(void)					{ return owner; }
		MTFileList *			GetOwningFileList(void);
		UInt8					OwnedBy(MTWindow * testWindow)	{ return owner == testWindow; }
	
	protected:
		virtual short			GetWindowType(void) = 0;
		virtual void			GetWindowSize(Rect * theRect) = 0;
		virtual void			GetWindowStandardSize(Rect * theRect) = 0;
		virtual void			GetWindowContentPadding(Rect * theRect) = 0;
		
		void					RegisterButtonControl(ControlHandle theControl)	{ SetControlReference(theControl, kButtonControlType); }
		void					RegisterHorzScrollControl(ControlHandle theControl);
		void					RegisterVertScrollControl(ControlHandle theControl);
		
		void					CreateScrollBars(UInt8 hasHorz, UInt8 hasVert);
		void					MoveScrollBars(UInt32 newWidth, UInt32 newHeight);
		
		WindowPtr				theWindow;
		
		ControlHandle			horzScroll, vertScroll, rootControl;
	
	private:
		MTWindowControlType		GetControlType(ControlHandle theControl);
		
		void					PadRect(Rect * target, Rect * padAmount);
		
		ControlActionUPP		scrollActionProcPtr;
		MTWindow				* owner;
};

struct MTWindowExtraWindowInfoRec
{
	CWindowRecord	window;
	MTWindow		* data;
};

MTWindow *	GetMTWindowFromWindowPtr(WindowPtr theWindow);

#endif /* __MT_WINDOW_H__ */